/**
 * @license Copyright (c) 2003-2016, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or http://ckeditor.com/license
 */

CKEDITOR.editorConfig = function( config ) {
	
	config.extraPlugins = "wordcount,justify,notification,entities,youtube";

	
	config.width = '100%';
	config.height = '300px';
	// The toolbar groups arrangement, optimized for two toolbar rows.
	
	

	config.toolbarGroups = [

		{ name: 'links' },
		{ name: 'insert' },
		{ name: 'forms' },
		{ name: 'tools' },		
		{ name: 'basicstyles', groups: [ 'basicstyles' ] },
		
		{ name: 'paragraph', groups: [ 'list', 'indent', 'blocks', 'align', 'bidi' ] },
		
		{ name: 'basicstyles', groups: [ 'basicstyles', 'cleanup' ] },
		{ name: 'paragraph',   groups: [ 'align', 'bidi' , 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock'] },
		{ name: 'styles' },
		{ name: 'colors' },
		{ name: 'document',	   groups: [ 'mode', 'document', 'doctools' ] }
	];
	
	

	// Remove some buttons provided by the standard plugins, which are
	// not needed in the Standard(s) toolbar.
	config.removeButtons = '';
	
	config.youtube_responsive = true; //Duyarlı
	config.youtube_related = false; //İlgili videoları göster
	config.youtube_older = false; //Eski gömme kodunu kullan
	config.youtube_privacy = false; //Gizlilik geliştirilmiş modunu etkinleştirin
	config.youtube_autoplay = false; //Videoyu otomatik olarak başlat
	config.youtube_controls = true; //Kontrolleri göster
	

	// Set the most common block elements.
	config.format_tags = 'p;h1;h2;h3;pre';

	// Simplify the dialog windows.
	config.removeDialogTabs = 'image:advanced;link:advanced';
	
	enterMode : CKEDITOR.ENTER_P,
	config.enterMode = CKEDITOR.ENTER_BR;
	
};
